
/*:

@target MZ
@plugindesc 文章の表示の名前で名前と顔グラを指定します。
@author メロウ紙芝居
@url https://meroukamisibai.com/

@param faceData
@text 顔グラデータ
@desc 呼ばれる顔グラを設定します。
@type struct<faceData>[]
@default []

@help MK_NameFace.js

文章の表示の名前の制御文字:
\NF[顔グラの名前]:
指定した顔グラの名前が名前になります。
さらに指定した顔グラの名前がパラメーターで設定したデータにある場合、
そのデータを読み込んで顔グラを表示させます。
指定した顔グラの名前を使わずに顔グラだけを読み込みたい場合は、
制御文字外のどこかに付けたい名前を入力してください。
例:
　\NF[ミル] → ミル
　\NF[ミル]あぼどん → あぼどん
　あぼどん\NF[ミル] → あぼどん

*/

/*~struct~faceData:

@param name
@text 名前
@desc この顔グラの名前です。
@type string

@param faceName
@text 画像ファイル
@desc 表示する画像ファイルです。
@type file
@dir img/faces/

@param faceIndex
@text 表示する顔グラ
@desc 表示する顔グラを指定します。(左上から0,1,2,3・・・)
@type number
@max 7
@min 0
@default 0

*/

(() => {
    
    /////////////////プラグイン関係/////////////////
    
    const pluginName = "MK_NameFace";
    
    //----------プラグインパラメーター----------
    
    const parameters = PluginManager.parameters(pluginName);
    const p_faceData = function() {
        let faceData = JSON.parse(parameters["faceData"]);
        for(let d in faceData){
            faceData[d] = JSON.parse(faceData[d]);
            faceData[d].faceIndex = Number(faceData[d].faceIndex);
        }
        return faceData;
    }();
    
    
    /////////////////元々オブジェクト/////////////////
    
    //名前制御文字
    const _Game_Message_setSpeakerName = Game_Message.prototype.setSpeakerName;
    Game_Message.prototype.setSpeakerName = function(speakerName) {
        if(!!speakerName){
            speakerName = speakerName.replace(/\\NF\[(.*?)\]/gi, (_, p1) =>
                this.MK_NameFace_Face(speakerName, _, p1)
            );
        }
        _Game_Message_setSpeakerName.apply(this, arguments);
    };
    
    //顔グラを設定して、表示する名前を返す
    Game_Message.prototype.MK_NameFace_Face = function(speakerName, word, name) {
        const face = p_faceData.find((face) => face.name == name);
        if(!!face){
            $gameMessage.setFaceImage(face.faceName, face.faceIndex);
        }
        return (speakerName.length == word.length) ? name : "";
    };
    
    //プリロード
    const _Game_Interpreter_loadImages = Game_Interpreter.prototype.loadImages;
    Game_Interpreter.prototype.loadImages = function() {
        _Game_Interpreter_loadImages.apply(this, arguments);
        const list = this._list.slice(0, 200);
        for(const command of list){
            if(command.code == 101 && !!command.parameters[4] && command.parameters[4].includes("\\NF")){
                const word = command.parameters[4].match(/\\NF\[(.*?)\]/gi);
                word.forEach((word) => {
                    const name = word.replace(/\\NF\[(.*?)\]/gi, (_, p1) => p1);
                    const face = p_faceData.find((faceData) => faceData.name == name);
                    if(!!face){
                        ImageManager.loadFace(face.faceName);
                    }
                });
            }
        }
    };
    
    
})();
